
library(doParallel)
library(rgenoud)
library(gam)
unregister_dopar <- function() {
  env <- foreach:::.foreachGlobals
  rm(list=ls(name=env), pos=env)
}
n=20000
p=2
times=400
sim_time=100

sim<- function(){
  # data generation
  x=matrix(runif(n*p,-1.5,1.5),n,p)
  x1=x[,1]
  x2=x[,2]
  logit=-1+0.8*x1+0.8*x2
  prob=1/(1+exp(-logit))
  a=rbinom(n,1,prob)
  #mu=2-1.5*x1-1.5*x2+a*(-x1-x2)
  
  contrast = 2*x1+x2
  baseline = 2-1.5*x1-1.5*x2
  y1star =  baseline + contrast + rnorm(n,0,1)
  y0star =  baseline + rnorm(n,0,1)
  y = rep(0, n)
  y[which(a==1)] = y1star[which(a==1)]
  y[which(a==0)] = y0star[which(a==0)] 
  
  
  data<- data.frame(y,a,x)
  
  
  treated.data <- data[a==1,]
  control.data <- data[a==0,]
  n.treated.pre <- nrow(treated.data)
  n.control.pre <- nrow(control.data)
  ps <- gam(a~s(X1)+s(X2), family = binomial, 
            data = data)
  pscore.probs <- predict(ps, newdata = data, type = "response")
  
  lm.t <- gam(y~s(X1)+s(X2),  
              data = treated.data)
  lm.c <- gam(y~s(X1)+s(X2), 
              data = control.data)
  outcome.treated.expectation <- (predict(lm.t, newdata = data, 
                                          type = "response"))
  outcome.control.expectation <- (predict(lm.c, newdata = data, 
                                          type = "response"))
  
  v_d<- function(b){
    action<- as.numeric(x %*% b > 0)
    pic<- pscore.probs*action+(1-pscore.probs)*(1-action)
    c<- as.numeric(action==a)
    mud<- outcome.treated.expectation*action+outcome.control.expectation*(1-action)
    return(mean(c*y/pic-(c-pic)/pic*mud))
  }

  dom <- matrix(c(-2,2,-2,2),2,2,T)
  
  
  
  result_opt <- genoud(v_d,nvars=2,
                       max=TRUE,pop.size=4000,
                       starting.values=c(0,0),print.level=0,
                       Domains=dom,optim.method="Nelder-Mead")

  bhat<- result_opt$par/norm(result_opt$par,'2')

  
  
  epis<- 0.5
  H<- matrix(0,p,p)
  for(k in 1:p){
    for(l in 1:p){
      ek<- el<- rep(0,p)
      ek[k]<- 1
      el[l]<- 1
      H[k,l]<- -1/4/epis^2*(v_d(bhat+ek*epis+el*epis)-v_d(bhat+ek*epis-el*epis)-v_d(bhat-ek*epis+el*epis)
                            +v_d(bhat-ek*epis-el*epis))
      
    }
  }
  
  
  #bootstrap
  bootstrap=function(data){
    uid=1:dim(data)[1]
    ids=sample(uid,length(uid),replace=T)
    boot_data=data[ids,]
    rownames(boot_data)<- NULL
    return(boot_data)
  }
  
  b_opt<- function(data){
    dat<- (bootstrap(data))
    b_x<- dat[,3:4]
    b_a<- dat[2]
    b_y<- dat[1]
    b_treated.data <- dat[a==1,]
    b_control.data <- dat[a==0,]
    b.n.treated.pre <- nrow(b_treated.data)
    b.n.control.pre <- nrow(b_control.data)
    b_ps <- gam(a~s(X1)+s(X2), family = binomial, 
                data = dat)
    b.pscore.probs <- predict(b_ps, newdata = dat, type = "response")
    
    
    b.lm.t <- gam(y~s(X1)+s(X2), 
                  data = b_treated.data)
    b.lm.c <- gam(y~s(X1)+s(X2),  
                  data =b_control.data)
    b.outcome.treated.expectation <- predict(b.lm.t, newdata = dat, 
                                             type = "response")
    b.outcome.control.expectation <- predict(b.lm.c, newdata = dat, 
                                             type = "response")
    m<- function(b){
      
      action<- as.numeric(data.matrix(b_x) %*% b > 0)
      c<- as.numeric(action==b_a)
      pic<- b.pscore.probs*action+(1-b.pscore.probs)*(1-action)
      
      mud<- b.outcome.treated.expectation*action+b.outcome.control.expectation*(1-action)
      mn<-  mean(c*data.matrix(b_y)/pic-(c-pic)/pic*mud)
      Mn<- v_d(b)
      minus<- 1/2*t(b-as.matrix(bhat))%*%H%*%(b-as.matrix(bhat))
      return(mn-Mn-minus)
      
    }
    b_result_opt <- genoud(m,nvars=2,
                           max=TRUE,pop.size=4000,print.level=0,
                           starting.values=c(0,0),
                           Domains=dom,optim.method="Nelder-Mead")
    b_bhat<- b_result_opt$par/norm(b_result_opt$par,'2')
    return(b_bhat)
  }
  
  
  
  
  samples<- matrix(0,times,2)
  for(i in 1:times){
    set.seed(i)
    tryCatch({
      ans<- b_opt(data)
      samples[i,]<- ans/norm(ans,'2')
    },error=function(e){
      samples[i,]=NA
    })
  }
  
  # samples<- foreach(i=1:times,.combine=rbind,.packages='rgenoud',.errorhandling = 'pass',.options.snow = list(type = "serial")) %dopar% {
  #   set.seed(i)
  #   ans<- b_opt(data)
  #   return(ans/norm(ans,'2'))
  # }
  
  return( list(true=bhat,samples=samples))
  
}

# parallel jobs
registerDoParallel(16)
llll<- foreach(k=1:sim_time,.combine=rbind,.packages='rgenoud',.errorhandling = 'pass') %dopar% {
  set.seed(k)
  ans<- sim()
  return(list(true=ans$true,samples=ans$samples))
  gc()
}
unregister_dopar()
stopImplicitCluster()



